from dotenv import load_dotenv

load_dotenv()
from openai import OpenAI

client = OpenAI()
import json


def find_product(sql_query):
    # Wysłanie zapytania do bazy
    results = [
        {"name": "pióro", "color": "niebieskie", "price": 199},
        {"name": "pióro", "color": "czerwone", "price": 178},

    ]
    return results


function_find_product = {
        "name": "find_product",
        "description": "Utworzenie listy produktów na podstawie zapytania SQL",
        "parameters": {
            "type": "object",
            "properties": {
                "sql_query": {
                    "type": "string",
                    "description": "Zapytanie SQL",
                }
            },
            "required": ["sql_query"],
        },
    }



def run(user_question):
    # Send the question and available functions to GPT
    messages = [{"role": "user", "content": user_question}]

    response = client.chat.completions.create(model="gpt-3.5-turbo-0613", messages=messages, tools=[{"type": "function", "function": function_find_product }])
    response_message = response.choices[0].message

    # Dołączenie odpowiedzi asystenta do wiadomości
    messages.append(response_message)
    

    # Wywołanie funkcji i dodanie wyników do wiadomości
    function_name = response_message.tool_calls[0].function.name
    if function_name == "find_product":
        function_args = json.loads(
            response_message.tool_calls[0].function.arguments
        )
        products = find_product(function_args.get("sql_query"))
    else:
        # Obsługa błędów
        products = []
    # Dołączenie odpowiedzi funckji do widomości
    messages.append(
        {
            "role": "tool",
            "content": json.dumps(products),
            "tool_call_id": response_message.tool_calls[0].id,
        }
    )
    # Uzyskanie nowej odpowiedzi od modelu GPT, aby mógł sformułować odpowiedź funkcji w języku naturalnym
    second_response = client.chat.completions.create(model="gpt-3.5-turbo-0613",
    messages=messages)
    return second_response.choices[0].message.content


print(run("Potrzebuję dwóch najlepszych produktów w cenie do 200 zł"))
